/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.workflow;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.region.VWConfigWebServicesPanel;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWPartnerLinksTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWWebServicesExplorerDialog;
import filenet.vw.toolkit.utils.event.IVWTableActionListener;
import filenet.vw.toolkit.utils.event.VWTableActionEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.uicontrols.border.IVWToolbarBorderActionListener;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderActionEvent;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorderClientActionEvent;
import filenet.ws.api.WSWSDLRefs;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import javax.swing.text.Document;

class VWPartnerLinksPanel
extends JPanel
implements IVWToolbarBorderActionListener,
TableModelListener,
ListSelectionListener,
IVWTableActionListener,
ActionListener,
ItemListener,
DocumentListener,
FocusListener {
    private VWToolbarBorder m_partnerLinksBorder = null;
    private VWTable m_partnerLinksTable = null;
    private VWPartnerLinksTableModel m_partnerLinksTableModel = null;
    private VWWebServicesExplorerDialog m_wsExplorerDialog = null;
    private JCheckBox m_invokeCheckBox = null;
    private JTextField m_wsdlUrlTextField = null;
    private JButton m_wsdlUrlBrowseButton = null;
    private JComboBox m_portTypeComboBox = null;
    private JTextField m_roleTextField = null;
    private JCheckBox m_receiveReplyCheckBox = null;
    private JTextField m_processPortTypeTextField = null;
    private JTextField m_processRoleTextField = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private boolean m_bEnableWSDLInput = true;
    private boolean m_bIsFirstTime = true;
    private int m_nCurrentRow = -1;

    public void paint(Graphics g) {
        super.paint(g);
        if (this.m_bIsFirstTime) {
            this.m_bIsFirstTime = false;
            if (this.m_partnerLinksTable != null) {
                TableColumn tcElement;
                int nameWidth;
                int[] columnSizes = null;
                int nWidth = this.m_partnerLinksTable.getViewPortWidth();
                if (this.m_authPropertyData.getShowInheritedProperties()) {
                    nameWidth = (this.m_partnerLinksTable.getViewPortWidth() - 20) * 2 / 3;
                    columnSizes = new int[]{20, nameWidth, nWidth - (columnSizes[0] + columnSizes[1])};
                } else {
                    nameWidth = nWidth * 2 / 3;
                    columnSizes = new int[]{nameWidth, nWidth - nameWidth};
                }
                this.m_partnerLinksTable.fitColumnsInTable(columnSizes);
                if (this.m_authPropertyData.getShowInheritedProperties() && (tcElement = this.m_partnerLinksTable.getColumnModel().getColumn(this.m_partnerLinksTableModel.getActualColumnIndex(0))) != null) {
                    tcElement.setMaxWidth(20);
                    tcElement.setMinWidth(20);
                }
            }
        }
    }

    public void toolbarBorderActionPerformed(VWToolbarBorderActionEvent event) {
        try {
            int nRowIndex;
            this.m_partnerLinksTable.stopEditing();
            if (event.getSource() == this.m_partnerLinksBorder && (nRowIndex = this.m_partnerLinksTable.getSelectedRow()) != -1) {
                switch (event.getID()) {
                    case 64: {
                        this.m_partnerLinksTableModel.copyItem(nRowIndex);
                        this.m_partnerLinksTable.ensureRowIsVisible(this.m_partnerLinksTable.getSelectedRow());
                        break;
                    }
                    case 0x10000000: {
                        this.m_partnerLinksTableModel.deleteItem(nRowIndex);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void tableChanged(TableModelEvent event) {
        switch (event.getType()) {
            case -1: 
            case 1: {
                int nRow = event.getLastRow();
                if (nRow < 0) {
                    nRow = 0;
                }
                if (nRow > this.m_partnerLinksTable.getRowCount() - 1) {
                    nRow = this.m_partnerLinksTable.getRowCount() - 1;
                }
                if (nRow == this.m_partnerLinksTable.getSelectedRow()) {
                    this.m_partnerLinksTable.clearSelection();
                }
                this.m_partnerLinksTable.setRowSelectionInterval(nRow, nRow);
                break;
            }
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        if (!event.getValueIsAdjusting()) {
            int rowCount;
            this.m_partnerLinksBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_partnerLinksBorder.getClientPanel(), 2, Integer.MAX_VALUE));
            int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
            if (this.m_partnerLinksTableModel != null && nRowIndex != -1 && nRowIndex != (rowCount = this.m_partnerLinksTableModel.getRowCount()) - 1) {
                int nButtons = 64;
                if (this.m_partnerLinksTableModel.canDeleteRow(nRowIndex)) {
                    nButtons |= 0x10000000;
                }
                this.m_partnerLinksBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_partnerLinksBorder.getClientPanel(), 1, nButtons));
            }
            this.updateParameters(nRowIndex);
        } else if (event.getFirstIndex() == this.m_nCurrentRow) {
            this.updateWsdlUrl(this.m_wsdlUrlTextField.getText(), this.m_nCurrentRow);
            this.m_nCurrentRow = -1;
        }
    }

    public void tableActionPerformed(VWTableActionEvent event) {
        switch (event.getID()) {
            case 100: {
                this.stopEditing();
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object src = event.getSource();
        if (src == this.m_invokeCheckBox) {
            this.performInvokeAction();
        } else if (src == this.m_wsdlUrlBrowseButton) {
            this.performWSDLUrlBrowse();
        } else if (src == this.m_receiveReplyCheckBox) {
            this.performReceiveReplyAction();
        }
    }

    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() != 1) {
            return;
        }
        if (event.getSource().equals(this.m_portTypeComboBox)) {
            this.performPortTypeAction();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        Document document = e.getDocument();
        if (document == this.m_roleTextField.getDocument()) {
            this.updateRole();
        } else if (document == this.m_processPortTypeTextField.getDocument()) {
            this.updateProcessPortType();
        } else if (document == this.m_processRoleTextField.getDocument()) {
            this.updateProcessRole();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    public void focusGained(FocusEvent event) {
        if (!event.isTemporary() && event.getComponent().equals(this.m_wsdlUrlTextField)) {
            this.m_nCurrentRow = this.m_partnerLinksTable.getSelectedRow();
        }
    }

    public void focusLost(FocusEvent event) {
        if (!event.isTemporary() && event.getComponent().equals(this.m_wsdlUrlTextField) && this.m_wsdlUrlTextField.isEditable() && this.m_nCurrentRow != -1) {
            this.updateWsdlUrl(this.m_wsdlUrlTextField.getText(), this.m_nCurrentRow);
            this.m_nCurrentRow = -1;
        }
    }

    protected void init(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            VWAttributeInfo vwAttributeInfo = null;
            VWSystemConfiguration sysConfig = this.m_authPropertyData.getDesignerCoreData().getDataDictionary().getSystemConfiguration();
            if (sysConfig != null) {
                vwAttributeInfo = sysConfig.getAttributeInfo();
            }
            this.m_bEnableWSDLInput = VWConfigWebServicesPanel.retrieveWSDLEnabled(this.m_authPropertyData.getVWSession(), vwAttributeInfo);
            this.m_bEnableWSDLInput |= this.m_authPropertyData.getDesignerCoreData().getSolutionHelper() != null;
            this.createControls();
            this.reinitialize();
            this.m_authPropertyData.getTableActionEventNotifier().addTableActionListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void reinitialize() {
        this.m_wsdlUrlTextField.setText(null);
        this.m_partnerLinksTableModel.reinitialize();
        this.m_partnerLinksTable.clearSelection();
        this.updateParameters(this.m_partnerLinksTable.getSelectedRow());
        this.refeshMainPanel();
    }

    protected void stopEditing() {
        if (this.m_partnerLinksTable != null) {
            this.m_partnerLinksTable.stopEditing();
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getTableActionEventNotifier().removeTableActionListener(this);
        if (this.m_partnerLinksBorder != null) {
            this.m_partnerLinksBorder.releaseReferences();
            this.m_partnerLinksBorder = null;
        }
        if (this.m_partnerLinksTable != null) {
            this.m_partnerLinksTable.getSelectionModel().removeListSelectionListener(this);
            this.m_partnerLinksTable = null;
        }
        if (this.m_partnerLinksTableModel != null) {
            this.m_partnerLinksTableModel.removeTableModelListener(this);
            this.m_partnerLinksTableModel = null;
        }
        if (this.m_wsExplorerDialog != null) {
            this.m_wsExplorerDialog.removeReferences();
            this.m_wsExplorerDialog = null;
        }
        if (this.m_invokeCheckBox != null) {
            this.m_invokeCheckBox.removeActionListener(this);
            this.m_invokeCheckBox = null;
        }
        if (this.m_wsdlUrlTextField != null) {
            this.m_wsdlUrlTextField.removeFocusListener(this);
            this.m_wsdlUrlTextField = null;
        }
        if (this.m_wsdlUrlBrowseButton != null) {
            this.m_wsdlUrlBrowseButton.removeActionListener(this);
            this.m_wsdlUrlBrowseButton = null;
        }
        if (this.m_portTypeComboBox != null) {
            this.m_portTypeComboBox.removeItemListener(this);
            this.m_portTypeComboBox = null;
        }
        if (this.m_roleTextField != null) {
            this.m_roleTextField.getDocument().removeDocumentListener(this);
            this.m_roleTextField = null;
        }
        if (this.m_receiveReplyCheckBox != null) {
            this.m_receiveReplyCheckBox.removeActionListener(this);
            this.m_receiveReplyCheckBox = null;
        }
        if (this.m_processPortTypeTextField != null) {
            this.m_processPortTypeTextField.getDocument().removeDocumentListener(this);
            this.m_processPortTypeTextField = null;
        }
        if (this.m_processRoleTextField != null) {
            this.m_processRoleTextField.getDocument().removeDocumentListener(this);
            this.m_processRoleTextField = null;
        }
        this.m_authPropertyData = null;
        this.removeAll();
    }

    private void createControls() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 1;
        gbCons.weightx = 0.3;
        gbCons.weighty = 1.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(5, 5, 5, 20);
        this.add((Component)this.getTablePanel(), gbCons);
        ++gbCons.gridx;
        gbCons.weightx = 0.7;
        gbCons.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.getParametersPanel(), gbCons);
    }

    private JPanel getTablePanel() {
        this.m_partnerLinksBorder = new VWToolbarBorder(VWResource.s_partnerLinks, 0x10000040);
        this.m_partnerLinksBorder.clientActionPerformed(new VWToolbarBorderClientActionEvent(this.m_partnerLinksBorder.getClientPanel(), 2, Integer.MAX_VALUE));
        this.m_partnerLinksBorder.addToolbarBorderActionNotifier(this);
        JPanel partnerLinksPanel = this.m_partnerLinksBorder.getClientPanel();
        partnerLinksPanel.setLayout(new BorderLayout());
        this.m_partnerLinksTableModel = new VWPartnerLinksTableModel(this.m_authPropertyData, this);
        this.m_partnerLinksTableModel.addTableModelListener(this);
        this.m_partnerLinksTable = new VWTable(this.m_partnerLinksTableModel);
        this.m_partnerLinksTable.setName("m_partnerLinksTable_VWPartnerLinksPanel");
        this.m_partnerLinksTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
        this.m_partnerLinksTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
        partnerLinksPanel.add(new JScrollPane(this.m_partnerLinksTable));
        ListSelectionModel selectionModel = this.m_partnerLinksTable.getSelectionModel();
        if (selectionModel != null) {
            selectionModel.addListSelectionListener(this);
            selectionModel.setSelectionMode(0);
        }
        return this.m_partnerLinksBorder;
    }

    private JPanel getParametersPanel() {
        JPanel parametersPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbCons = new GridBagConstraints();
        gbCons.gridx = 0;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.weighty = 0.0;
        gbCons.anchor = 23;
        gbCons.gridheight = 1;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 15);
        this.m_invokeCheckBox = new JCheckBox(VWResource.s_invoke);
        this.m_invokeCheckBox.setSelected(false);
        this.m_invokeCheckBox.addActionListener(this);
        parametersPanel.add((Component)this.m_invokeCheckBox, gbCons);
        ++gbCons.gridy;
        gbCons.insets = new Insets(2, 20, 0, 5);
        parametersPanel.add((Component)new JLabel(VWResource.s_wsdlURL), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.insets = new Insets(2, 0, 0, 5);
        this.m_wsdlUrlTextField = new JTextField();
        this.m_wsdlUrlTextField.setName("m_wsdlUrlTextField_VWPartnerLinksPanel");
        this.m_wsdlUrlTextField.setEditable(false);
        this.m_wsdlUrlTextField.addFocusListener(this);
        parametersPanel.add((Component)this.m_wsdlUrlTextField, gbCons);
        ++gbCons.gridx;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(2, 0, 0, 20);
        this.m_wsdlUrlBrowseButton = VWImageLoader.createIconButton("dots.gif", VWResource.s_webServicesExplorer);
        this.m_wsdlUrlBrowseButton.setName("m_wsdlUrlBrowseButton_VWPartnerLinksPanel");
        this.m_wsdlUrlBrowseButton.setEnabled(false);
        this.m_wsdlUrlBrowseButton.addActionListener(this);
        parametersPanel.add((Component)this.m_wsdlUrlBrowseButton, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.insets = new Insets(2, 20, 0, 5);
        parametersPanel.add((Component)new JLabel(VWResource.s_portType), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.gridwidth = 2;
        gbCons.insets = new Insets(2, 0, 0, 20);
        this.m_portTypeComboBox = new JComboBox();
        this.m_portTypeComboBox.setName("m_portTypeComboBox_VWPartnerLinksPanel");
        this.m_portTypeComboBox.setRenderer(new VWLabelListCellRenderer());
        this.m_portTypeComboBox.setEnabled(false);
        parametersPanel.add((Component)this.m_portTypeComboBox, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(2, 20, 0, 5);
        parametersPanel.add((Component)new JLabel(VWResource.s_role), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.gridwidth = 2;
        gbCons.insets = new Insets(2, 0, 0, 20);
        this.m_roleTextField = new JTextField();
        this.m_roleTextField.setName("m_roleTextField_VWPartnerLinksPanel");
        this.m_roleTextField.setEditable(false);
        this.m_roleTextField.getDocument().addDocumentListener(this);
        parametersPanel.add((Component)this.m_roleTextField, gbCons);
        gbCons.gridx = 3;
        gbCons.gridy = 0;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.gridwidth = 1;
        gbCons.insets = new Insets(0, 0, 0, 15);
        this.m_receiveReplyCheckBox = new JCheckBox(VWResource.s_receiveReply);
        this.m_receiveReplyCheckBox.setSelected(false);
        this.m_receiveReplyCheckBox.addActionListener(this);
        parametersPanel.add((Component)this.m_receiveReplyCheckBox, gbCons);
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(2, 20, 0, 5);
        parametersPanel.add((Component)new JLabel(VWResource.s_processPortType), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.insets = new Insets(2, 0, 0, 15);
        this.m_processPortTypeTextField = new JTextField();
        this.m_processPortTypeTextField.setName("m_processPortTypeTextField_VWPartnerLinksPanel");
        this.m_processPortTypeTextField.setEditable(false);
        this.m_processPortTypeTextField.getDocument().addDocumentListener(this);
        parametersPanel.add((Component)this.m_processPortTypeTextField, gbCons);
        gbCons.gridx = 3;
        ++gbCons.gridy;
        gbCons.fill = 0;
        gbCons.weightx = 0.0;
        gbCons.insets = new Insets(2, 20, 0, 5);
        parametersPanel.add((Component)new JLabel(VWResource.s_processRole), gbCons);
        ++gbCons.gridx;
        gbCons.fill = 2;
        gbCons.weightx = 0.5;
        gbCons.insets = new Insets(2, 0, 0, 15);
        this.m_processRoleTextField = new JTextField();
        this.m_processRoleTextField.setName("m_processRoleTextField_VWPartnerLinksPanel");
        this.m_processRoleTextField.setEditable(false);
        this.m_processRoleTextField.getDocument().addDocumentListener(this);
        parametersPanel.add((Component)this.m_processRoleTextField, gbCons);
        gbCons.gridx = 0;
        ++gbCons.gridy;
        gbCons.fill = 1;
        gbCons.weightx = 1.0;
        gbCons.weighty = 1.0;
        gbCons.gridwidth = 0;
        parametersPanel.add((Component)new JLabel(), gbCons);
        return parametersPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePortTypeComboBox() {
        try {
            try {
                this.m_authPropertyData.displayWaitCursor(this);
                this.m_portTypeComboBox.removeAllItems();
                this.m_portTypeComboBox.addItem(VWResource.s_noneItemStr);
                VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                if (wsUtils != null) {
                    String wsdlRef = this.m_partnerLinksTableModel.getWSDLRef(this.m_partnerLinksTable.getSelectedRow());
                    String[] portTypes = wsUtils.getPortTypes(new WSWSDLRefs(this.m_wsdlUrlTextField.getText(), wsdlRef).toString(), this);
                    if (portTypes != null && portTypes.length > 0) {
                        for (int i = 0; i < portTypes.length; ++i) {
                            this.m_portTypeComboBox.addItem(portTypes[i]);
                        }
                    }
                }
                Object var6_6 = null;
                this.m_authPropertyData.restoreDefaultCursor(this);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var6_7 = null;
                this.m_authPropertyData.restoreDefaultCursor(this);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.m_authPropertyData.restoreDefaultCursor(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateParameters(int nRowIndex) {
        this.m_invokeCheckBox.removeActionListener(this);
        this.m_wsdlUrlTextField.removeFocusListener(this);
        this.m_portTypeComboBox.removeItemListener(this);
        this.m_roleTextField.getDocument().removeDocumentListener(this);
        this.m_receiveReplyCheckBox.removeActionListener(this);
        this.m_processPortTypeTextField.getDocument().removeDocumentListener(this);
        this.m_processRoleTextField.getDocument().removeDocumentListener(this);
        try {
            try {
                String type;
                this.m_authPropertyData.displayWaitCursor(this);
                String strValue = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(3));
                this.m_wsdlUrlTextField.setText(strValue);
                this.m_wsdlUrlTextField.setToolTipText(strValue);
                String role = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(5));
                this.m_roleTextField.setText(role);
                String processPortType = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(6));
                this.m_processPortTypeTextField.setText(processPortType);
                String processRole = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(7));
                this.m_processRoleTextField.setText(processRole);
                boolean bEnableInvoke = false;
                boolean bEnableReply = false;
                boolean bCanEditItem = this.m_partnerLinksTableModel.canDeleteRow(nRowIndex);
                if (nRowIndex == this.m_partnerLinksTableModel.getRowCount() - 1) {
                    bCanEditItem = true;
                }
                if (VWStringUtils.compare(type = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(2)), VWResource.s_invoke) == 0) {
                    bEnableInvoke = true;
                } else if (VWStringUtils.compare(type, VWResource.s_receiveReply) == 0) {
                    bEnableReply = true;
                } else if (VWStringUtils.compare(type, VWResource.s_both) == 0) {
                    bEnableInvoke = true;
                    bEnableReply = true;
                }
                this.m_invokeCheckBox.setSelected(bEnableInvoke);
                this.m_invokeCheckBox.setEnabled(bCanEditItem);
                this.m_wsdlUrlTextField.setEditable(bEnableInvoke && this.m_bEnableWSDLInput && bCanEditItem);
                this.m_wsdlUrlBrowseButton.setEnabled(bEnableInvoke && bCanEditItem);
                this.m_portTypeComboBox.setEnabled(bEnableInvoke && bCanEditItem);
                this.m_roleTextField.setEditable(bEnableInvoke && bCanEditItem);
                this.m_receiveReplyCheckBox.setSelected(bEnableReply);
                this.m_receiveReplyCheckBox.setEnabled(bCanEditItem);
                this.m_processPortTypeTextField.setEditable(bEnableReply && bCanEditItem);
                this.m_processRoleTextField.setEditable(bEnableReply && bCanEditItem);
                this.updatePortTypeComboBox();
                String portType = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(4));
                if (portType == null || portType.length() == 0) {
                    this.m_portTypeComboBox.setSelectedIndex(0);
                }
                this.m_portTypeComboBox.setSelectedItem(portType);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var12_13 = null;
                this.m_invokeCheckBox.addActionListener(this);
                this.m_wsdlUrlTextField.addFocusListener(this);
                this.m_portTypeComboBox.addItemListener(this);
                this.m_roleTextField.getDocument().addDocumentListener(this);
                this.m_receiveReplyCheckBox.addActionListener(this);
                this.m_processPortTypeTextField.getDocument().addDocumentListener(this);
                this.m_processRoleTextField.getDocument().addDocumentListener(this);
                this.m_authPropertyData.restoreDefaultCursor(this);
                return;
            }
            Object var12_12 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.m_invokeCheckBox.addActionListener(this);
            this.m_wsdlUrlTextField.addFocusListener(this);
            this.m_portTypeComboBox.addItemListener(this);
            this.m_roleTextField.getDocument().addDocumentListener(this);
            this.m_receiveReplyCheckBox.addActionListener(this);
            this.m_processPortTypeTextField.getDocument().addDocumentListener(this);
            this.m_processRoleTextField.getDocument().addDocumentListener(this);
            this.m_authPropertyData.restoreDefaultCursor(this);
            throw throwable;
        }
        this.m_invokeCheckBox.addActionListener(this);
        this.m_wsdlUrlTextField.addFocusListener(this);
        this.m_portTypeComboBox.addItemListener(this);
        this.m_roleTextField.getDocument().addDocumentListener(this);
        this.m_receiveReplyCheckBox.addActionListener(this);
        this.m_processPortTypeTextField.getDocument().addDocumentListener(this);
        this.m_processRoleTextField.getDocument().addDocumentListener(this);
        this.m_authPropertyData.restoreDefaultCursor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performInvokeAction() {
        boolean bIsSelected = this.m_invokeCheckBox.isSelected();
        this.m_wsdlUrlTextField.setEditable(bIsSelected && this.m_bEnableWSDLInput);
        this.m_wsdlUrlBrowseButton.setEnabled(bIsSelected);
        this.m_portTypeComboBox.setEnabled(bIsSelected);
        this.m_roleTextField.setEditable(bIsSelected);
        try {
            try {
                this.m_roleTextField.getDocument().removeDocumentListener(this);
                if (!bIsSelected) {
                    this.m_wsdlUrlTextField.setText("");
                    this.m_wsdlUrlTextField.setToolTipText(null);
                    this.updatePortTypeComboBox();
                    this.m_roleTextField.setText("");
                }
                int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
                if (bIsSelected) {
                    this.m_partnerLinksTableModel.setValueAt("", nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(3));
                } else {
                    this.m_partnerLinksTableModel.setValueAt(null, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(3));
                }
                this.m_partnerLinksTableModel.setValueAt(null, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(4));
                this.m_partnerLinksTableModel.setValueAt(null, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(5));
                this.refeshMainPanel();
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                Object var4_5 = null;
                this.m_roleTextField.getDocument().addDocumentListener(this);
            }
            Object var4_4 = null;
            this.m_roleTextField.getDocument().addDocumentListener(this);
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.m_roleTextField.getDocument().addDocumentListener(this);
            throw throwable;
        }
    }

    private void performWSDLUrlBrowse() {
        this.m_authPropertyData.displayWaitCursor(this);
        if (this.m_wsExplorerDialog == null) {
            this.m_wsExplorerDialog = new VWWebServicesExplorerDialog(this.m_authPropertyData.getMainContainer(), this.m_authPropertyData.getVWSession(), null);
        }
        this.m_wsExplorerDialog.setVisible(true);
        if (!this.m_wsExplorerDialog.isCanceled()) {
            String endPoint = this.m_wsExplorerDialog.getSelectedWSDL();
            this.updateWsdlUrl(endPoint, this.m_partnerLinksTable.getSelectedRow());
        }
        this.m_authPropertyData.restoreDefaultCursor(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateWsdlUrl(String newWsdlUrl, int nRowIndex) {
        block8: {
            try {
                try {
                    this.m_authPropertyData.displayWaitCursor(this);
                    String currentEndPoint = (String)this.m_partnerLinksTableModel.getValueAt(nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(3));
                    if (currentEndPoint != null && VWStringUtils.compare(currentEndPoint, newWsdlUrl) == 0) {
                        Object var7_5 = null;
                        this.m_authPropertyData.restoreDefaultCursor(this);
                        return;
                    }
                    this.m_partnerLinksTableModel.setValueAt(newWsdlUrl, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(3));
                    this.m_wsdlUrlTextField.setText(newWsdlUrl);
                    this.m_wsdlUrlTextField.setToolTipText(newWsdlUrl);
                    this.updatePortTypeComboBox();
                    int nPortCount = this.m_portTypeComboBox.getModel().getSize();
                    if (nPortCount <= 0) break block8;
                    if (nPortCount == 2) {
                        this.m_portTypeComboBox.setSelectedIndex(1);
                        String portType = (String)this.m_portTypeComboBox.getSelectedItem();
                        this.m_partnerLinksTableModel.setValueAt(portType, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(4));
                    } else {
                        this.m_portTypeComboBox.setSelectedIndex(0);
                        this.m_partnerLinksTableModel.setValueAt(null, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(4));
                    }
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                    Object var7_7 = null;
                    this.m_authPropertyData.restoreDefaultCursor(this);
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.m_authPropertyData.restoreDefaultCursor(this);
                throw throwable;
            }
        }
        Object var7_6 = null;
        this.m_authPropertyData.restoreDefaultCursor(this);
    }

    private void performPortTypeAction() {
        try {
            String portType = (String)this.m_portTypeComboBox.getSelectedItem();
            if (VWStringUtils.compare(portType, VWResource.s_noneItemStr) == 0) {
                portType = null;
            }
            int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
            this.m_partnerLinksTableModel.setValueAt(portType, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(4));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateRole() {
        try {
            String role = this.m_roleTextField.getText();
            int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
            this.m_partnerLinksTableModel.setValueAt(role, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(5));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void performReceiveReplyAction() {
        boolean bIsSelected = this.m_receiveReplyCheckBox.isSelected();
        this.m_processPortTypeTextField.setEditable(bIsSelected);
        this.m_processRoleTextField.setEditable(bIsSelected);
        try {
            int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
            if (!bIsSelected) {
                this.m_processPortTypeTextField.getDocument().removeDocumentListener(this);
                this.m_processRoleTextField.getDocument().removeDocumentListener(this);
                this.m_processPortTypeTextField.setText("");
                this.m_processRoleTextField.setText("");
                this.m_processRoleTextField.getDocument().addDocumentListener(this);
                this.m_processPortTypeTextField.getDocument().addDocumentListener(this);
                this.m_partnerLinksTableModel.setValueAt(null, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(6));
                this.m_partnerLinksTableModel.setValueAt(null, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(7));
            } else {
                this.m_partnerLinksTableModel.setValueAt("", nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(6));
                this.m_partnerLinksTableModel.setValueAt("", nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(7));
            }
            this.refeshMainPanel();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateProcessPortType() {
        try {
            String processPortType = this.m_processPortTypeTextField.getText();
            int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
            this.m_partnerLinksTableModel.setValueAt(processPortType, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(6));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void updateProcessRole() {
        try {
            String processRole = this.m_processRoleTextField.getText();
            int nRowIndex = this.m_partnerLinksTable.getSelectedRow();
            this.m_partnerLinksTableModel.setValueAt(processRole, nRowIndex, this.m_partnerLinksTableModel.getActualColumnIndex(7));
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void refeshMainPanel() {
        this.m_bIsFirstTime = true;
        this.invalidate();
        this.validate();
        this.repaint();
    }
}

